// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
_centroid in highp vec2 uv;
#else
_centroid in vec2 uv;
#endif

#else
varying vec2 uv;
#endif

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"
#include "util.h"

/////////////////////////////////////////////////////////////////
///////////////////////// STOP! /////////////////////////////////
/////////////////////////////////////////////////////////////////
// Made by Sad - @bamboo_sapling
// successfully changed on Dec 2020.
// all of these assets are under MIT license.
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

varying highp vec3 spos;

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
uniform highp float TOTAL_REAL_WORLD_TIME;

#include "lib/bsbe.glsl"
#include "lib/colorp.glsl"

void main(){

#if !defined(TEXEL_AA) || !defined(TEXEL_AA_FEATURE)
	vec4 diffuse = texture2D( TEXTURE_0, uv );
#else
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv );
#endif

	float btex = texture2D(TEXTURE_0, vec2(.5,.5) ).r;
	vec3 tot = mix(mix(scolor,mcolor,nfog),fc.rgb+fc.r+fc.r+fc.r+fc.r+fc.r,rain);
	float size = 10., r =.13;
	float l = length(spos.xz);
	if(btex > .5){
		tot += max(.01/pow(l*size,8.),0.);
 		tot *= exp(.9-l)/mix(6.,15.,dfog);
	} else {
// Moon phase base code from Esbe2g by @McbeEringi
    	float mp = (floor(uv.x*4.)*.25+step(uv.y,.5))*3.14;
 		vec3 n = normalize(vec3(spos.xz,sqrt(r*r-l*l)));
		tot *= smoothstep(-.3,.2,dot(-vec3(sin(mp),0.,cos(mp)),n));
 		tot *= smoothstep(r,r-r*.03,l);
		tot += (exp(.5-l)/5.)*smoothstep(-1.,0.,dot(-vec3(sin(mp),0.,cos(mp)),n));
	}
	diffuse.rgb = tot*CURRENT_COLOR.rgb;

gl_FragColor = diffuse;
}
